/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.datetime;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardBaseTask;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardFrame;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.WizardTaskPanel;
import com.ibm.hsc.iw.WizardTaskState;
import com.ibm.hsc.iw.tasks.datetime.DateTimeConstants;
import com.ibm.hsc.iw.tasks.datetime.DateTimeState;
import com.ibm.hsc.iw.tasks.datetime.RestartRMCThread;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DateTimeTask
extends WizardBaseTask
implements DateTimeConstants {
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";
    private static final String TRACE_MASKD = "JIWZCDTD";
    private static final String TRACE_MASKF = "JIWZCDTF";
    private static final String TRACE_MASKT = "JIWZCDTT";
    private static final String MOD_HSC_BUILD_FILE = "/opt/hsc/bin/modHscBuildDat";
    private boolean update = false;

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public LocalizableText getDescription() {
        return new LocalizableText("com.ibm.hsc.common.bundles.DateTimeText", "TASK_DESCRIPTION");
    }

    public WizardTaskState init(WizardFrame wizardFrame) {
        return this._init();
    }

    public void exit() {
    }

    public WizardTaskState nextButtonHit(Serializable serializable) throws WizardTaskException {
        DateTimeState dateTimeState = (DateTimeState)serializable;
        Calendar calendar = dateTimeState.getEntryDateTime();
        String string = dateTimeState.getEntryTimezone();
        Calendar calendar2 = dateTimeState.getExitDateTime();
        String string2 = dateTimeState.getExitTimezone();
        if (string.equals(string2)) {
            int n;
            int n2 = calendar.get(1);
            if (n2 == (n = calendar2.get(1))) {
                int n3;
                int n4 = calendar.get(2);
                if (n4 == (n3 = calendar2.get(2))) {
                    int n5;
                    int n6 = calendar.get(5);
                    if (n6 == (n5 = calendar2.get(5))) {
                        int n7;
                        int n8 = calendar.get(10);
                        if (n8 == (n7 = calendar2.get(10))) {
                            int n9;
                            int n10 = calendar.get(9);
                            if (n10 == (n9 = calendar2.get(9))) {
                                int n11;
                                int n12 = calendar.get(11);
                                if (n12 == (n11 = calendar2.get(11))) {
                                    int n13;
                                    int n14 = calendar.get(12);
                                    if (n14 == (n13 = calendar2.get(12))) {
                                        int n15;
                                        int n16 = calendar.get(13);
                                        if (n16 != (n15 = calendar2.get(13))) {
                                            this.update = true;
                                        }
                                    } else {
                                        this.update = true;
                                    }
                                } else {
                                    this.update = true;
                                }
                            } else {
                                this.update = true;
                            }
                        } else {
                            this.update = true;
                        }
                    } else {
                        this.update = true;
                    }
                } else {
                    this.update = true;
                }
            } else {
                this.update = true;
            }
        } else {
            this.update = true;
        }
        if (this.update) {
            block20: {
                try {
                    this.setHMCTimezone(string2);
                    this.setHMCdatetime(calendar2);
                }
                catch (Exception exception) {
                    if (2 > Trace.LEVEL) break block20;
                    Trace.trace(TRACE_MASKF, "-- exception caught setting the new date/time: <" + exception + ">");
                }
            }
            DateTimeTask.restartRMC();
        }
        return new WizardTaskState(null, serializable);
    }

    public Object backButtonHit(Serializable serializable) {
        return serializable;
    }

    public Object backedIntoPanel(WizardTaskState wizardTaskState) {
        String string = this.getHMCtimezone();
        Calendar calendar = this.getHMCdatetime();
        return new DateTimeState(calendar, string, null, null);
    }

    public LocalizableText[] prepareToCommit(Object object) {
        ArrayList<LocalizableText> arrayList = null;
        LocalizableText localizableText = null;
        if (this.update) {
            arrayList = new ArrayList<LocalizableText>();
            localizableText = new LocalizableText("com.ibm.hsc.common.bundles.DateTimeText", "DATETIME_WAS_CHANGED");
            arrayList.add(localizableText);
            return arrayList.toArray(new LocalizableText[1]);
        }
        return null;
    }

    public WizardCommitStatus commit(Object object) {
        boolean bl = false;
        if (object != null) {
            DateTimeState dateTimeState = (DateTimeState)object;
            String string = dateTimeState.getEntryTimezone();
            if (string != null) {
                if (!string.equals(dateTimeState.getExitTimezone())) {
                    bl = true;
                }
            } else if (dateTimeState.getExitTimezone() != null && dateTimeState.getExitTimezone().length() > 0) {
                bl = true;
            }
        }
        if (bl) {
            return new WizardCommitStatus(true, null, null, false, true);
        }
        return new WizardCommitStatus(true, null);
    }

    private String getHMCtimezone() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> DateTimeTask.getHMCtimezone()");
        }
        String string = "";
        String string2 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("find") + " /etc/localtime -type l -printf \"%l:\"";
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "-- command to execute is <" + string2 + ">");
        }
        try {
            EExecResult eExecResult = EExec.Exec((String)string2);
            if (eExecResult.rc == 0) {
                String string3 = eExecResult.getStdout();
                if (string3 != null) {
                    if (string3.length() > 20) {
                        int n = string3.indexOf(":");
                        if (n != -1) {
                            string = string3.substring(20, n);
                        }
                    } else if (string3.length() == 0) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "stdout result length is 0");
                        }
                        BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/sysconfig/clock"));
                        String string4 = null;
                        while ((string4 = bufferedReader.readLine()) != null) {
                            if (!string4.startsWith("TIMEZONE=")) continue;
                            string = string4.substring(10, string4.length() - 1);
                            if (2 > Trace.LEVEL) continue;
                            Trace.trace(TRACE_MASKF, "timezone entry determined from /etc/sysconfig/clock file");
                        }
                    } else if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "stdout result length is less than 20 and not 0");
                        Trace.trace(TRACE_MASKF, "stderr=" + eExecResult.getStderr());
                    }
                } else if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "stdout appears null from execResult");
                    Trace.trace(TRACE_MASKF, "stderr=" + eExecResult.getStderr());
                }
            } else if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Return code is non null from command, rc=" + eExecResult.rc);
                Trace.trace(TRACE_MASKF, "stderr=" + eExecResult.getStderr());
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Exception during exec of command");
                Trace.trace(TRACE_MASKF, exception);
            }
            new AusMicrocodeLog(LOG_INFO, 2).writeEntryFromTaskletClient();
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "-- current timezone returned is <" + string + ">");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- DateTimeTask.getHMCtimezone()");
        }
        return string;
    }

    private Calendar getHMCdatetime() {
        GregorianCalendar gregorianCalendar;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> DateTimeTask.getHMCdatetime()");
        }
        String string = Crypt.encrypt("date") + " +%Y:%m:%d:%H:%M:%S";
        String string2 = new String("/opt/hsc/bin/hscdc " + string);
        EExecResult eExecResult = EExec.Exec((String)string2);
        if (eExecResult.rc != 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "system 'date' command failed rc = " + eExecResult.rc);
            }
            gregorianCalendar = new GregorianCalendar();
        } else if (eExecResult.stdout != null) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "date command returned " + eExecResult.stdout.trim());
            }
            String[] stringArray = new String[6];
            StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout.trim(), ":");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                if (n == 1) {
                    int n2 = Integer.parseInt(stringArray[n]);
                    stringArray[n] = Integer.toString(--n2);
                }
                ++n;
            }
            gregorianCalendar = new GregorianCalendar(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]));
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "system 'date' stdout returned null value");
            }
            gregorianCalendar = new GregorianCalendar();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- DateTimeTask.getHMCdatetime()");
        }
        return gregorianCalendar;
    }

    private void setHMCdatetime(Calendar calendar) throws Exception {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> DateTimeTask.setHMCdatetime()");
        }
        try {
            calendar.setTime(calendar.getTime());
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            int n4 = 1 + calendar.get(2);
            int n5 = calendar.get(5);
            int n6 = calendar.get(1);
            String string = Integer.toString(n4) + '/' + Integer.toString(n5) + "/" + Integer.toString(n6);
            String string2 = Integer.toString(n) + ":" + Integer.toString(n2) + ':' + Integer.toString(n3);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- input date/time strings are: " + string + "/" + string2);
            }
            String[] stringArray = new String[3];
            stringArray[0] = "/bin/date";
            stringArray[1] = "--set=\"" + string + " " + string2 + "\"";
            String string3 = "/sbin/hwclock";
            stringArray[2] = "--systohc --utc";
            EExecResult eExecResult = null;
            String string4 = new String("/opt/hsc/bin/hscdc " + Crypt.encrypt(stringArray[0]) + " " + stringArray[1]);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- date set command to be issued is: <" + string4 + ">");
            }
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc != 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "date time rc = " + eExecResult.rc);
                }
                new AusMicrocodeLog(LOG_INFO, 6).writeEntry(null);
                throw new Exception("'date --set' cmd failure");
            }
            string4 = new String("/opt/hsc/bin/hscdc " + Crypt.encrypt(string3) + " " + stringArray[2]);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- hwclock command to be issued is: <" + string4 + ">");
            }
            eExecResult = EExec.Exec((String)string4);
            if (eExecResult.rc != 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "hwclock -hctosys error  = " + eExecResult.rc);
                }
                new AusMicrocodeLog(LOG_INFO, 7).writeEntry(null);
                throw new Exception("hwclock failure");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "about to call hscbuild.dat modification routine...");
            }
            EExecResult eExecResult2 = null;
            string4 = new String("/opt/hsc/bin/hscdc " + Crypt.encrypt(MOD_HSC_BUILD_FILE));
            eExecResult2 = EExec.Exec((String)string4);
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "return from modHscBuildDatFile() is: " + eExecResult2.rc);
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- setHMCdatetime: caught unexpected exception: " + exception);
            }
            new AusMicrocodeLog(LOG_INFO, 8, exception).writeEntry(null);
            throw exception;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- DateTimeTask.setHMCdatetime()");
        }
    }

    private void setHMCTimezone(String string) throws Exception {
        Object object;
        String string2;
        EExecResult eExecResult;
        BufferedReader bufferedReader;
        BufferedWriter bufferedWriter;
        FileWriter fileWriter;
        File file;
        File file2;
        block41: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "-> DateTimeTask.setHMCTimezone()");
            }
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- zone to be set is <" + string + ">");
            }
            file2 = new File("/tmp/");
            file = null;
            fileWriter = null;
            bufferedWriter = null;
            bufferedReader = null;
            eExecResult = null;
            Properties properties = new Properties();
            string2 = "<not initialized>";
            try {
                object = ResourceBundle.getBundle("com.ibm.hsc.iw.tasks.datetime.res.TimezoneList");
                string2 = (String)((ResourceBundle)object).getObject("TZ0");
            }
            catch (Exception exception) {
                if (2 > Trace.LEVEL) break block41;
                Trace.trace(TRACE_MASKF, "-- exception while processing properties file: " + exception);
            }
        }
        if (string == null || string2.equals(string)) {
            String string3;
            object = new File("/etc/localtime");
            if (((File)object).exists() && ((File)object).isFile()) {
                try {
                    string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("rm") + " -f /etc/localtime";
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "-- command to execute is <" + string3 + ">");
                    }
                    eExecResult = EExec.Exec((String)string3);
                }
                catch (Exception exception) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "Exception deleting file <" + object + ">: " + exception);
                    }
                    new AusMicrocodeLog(LOG_INFO, 3, exception).writeEntry(null);
                    throw exception;
                }
            } else if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "File /etc/localtime does not exist. Continuing...");
            }
            try {
                String string4;
                file = File.createTempFile("tmp", "", file2);
                fileWriter = new FileWriter(file);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedReader = new BufferedReader(new FileReader("/etc/sysconfig/clock"));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.startsWith("HWCLOCK=")) {
                        string4 = string4.substring(0, 8).trim() + "\"-u\"";
                    } else if (string4.startsWith("TIMEZONE=")) {
                        string4 = string4.substring(0, 9).trim();
                    }
                    bufferedWriter.write(string4, 0, string4.length());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                string3 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file.getPath() + " /etc/sysconfig/clock";
                eExecResult = EExec.Exec((String)string3);
                if (2 <= Trace.LEVEL) {
                    if (eExecResult.rc == 0) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Timezone successfully removed from /etc/sysconfig/clock");
                        }
                    } else {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "failed to remove the timezone from /etc/sysconfig/clock. rc = " + eExecResult.rc);
                        }
                        new AusMicrocodeLog(LOG_INFO, 5).writeEntry(null);
                    }
                }
                file.delete();
            }
            catch (Exception exception) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Exception caught while trying to remove timezone entry from /etc/localtime: " + exception);
                }
                new AusMicrocodeLog(LOG_INFO, 5, exception).writeEntry(null);
                throw exception;
            }
        }
        try {
            String string5 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("ln") + " -sf /usr/share/zoneinfo/" + string + " /etc/localtime";
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- command to execute is <" + string5 + ">");
            }
            eExecResult = EExec.Exec((String)string5);
            if (eExecResult.rc == 0) {
                String string6;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Timezone successfully set to <" + string + ">");
                }
                file = File.createTempFile("tmp", "", file2);
                fileWriter = new FileWriter(file);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedReader = new BufferedReader(new FileReader("/etc/sysconfig/clock"));
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (string6.startsWith("HWCLOCK=")) {
                        string6 = string6.substring(0, 8) + "\"-u\"";
                    } else if (string6.startsWith("TIMEZONE=")) {
                        string6 = string6.substring(0, 9) + "\"" + string + "\"";
                    }
                    bufferedWriter.write(string6, 0, string6.length());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                string5 = "/opt/hsc/bin/hscdc " + Crypt.encrypt("cp") + " -f " + file.getPath() + " /etc/sysconfig/clock";
                eExecResult = EExec.Exec((String)string5);
                if (2 <= Trace.LEVEL) {
                    if (eExecResult.rc == 0) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "Timezone successfully set to <" + string + "> in /etc/sysconfig/clock");
                        }
                    } else {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "failed to set the timezone file to <" + string + "> in /etc/sysconfig/clock.  rc = " + eExecResult.rc);
                        }
                        new AusMicrocodeLog(LOG_INFO, 9).writeEntry(null);
                    }
                }
            } else {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "failed to set the timezone file to <" + string + ">.  rc = " + eExecResult.rc);
                }
                new AusMicrocodeLog(LOG_INFO, 9).writeEntry(null);
                throw new Exception("failed to set Timezone");
            }
            file.delete();
        }
        catch (Exception exception) {
            new AusMicrocodeLog(LOG_INFO, 4, exception).writeEntry(null);
            throw exception;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- hscDateTime.SetCurrentTimeZone()");
        }
    }

    public WizardTaskState reEnter(Object object) throws WizardTaskException {
        return this._init();
    }

    private WizardTaskState _init() {
        String string = this.getHMCtimezone();
        Calendar calendar = this.getHMCdatetime();
        return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.datetime.res.DateTime", "date_time", "com.ibm.hsc.iw.tasks.datetime.DateTimeBean"), new DateTimeState(calendar, string, null, null));
    }

    public static void restartRMC() {
        new Thread((Runnable)new RestartRMCThread(), "Restart RMC").start();
    }
}

